"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sub = void 0;
/**
 * Crops the matrix and returns a window at position `[x,y]` of size `[xlen, ylen]` from the input
 * matrix
 *
 * @method sub
 * @param {Matrix} A - The input matrix
 * @param {Number} x - The starting x offset
 * @param {Number} height - The vertical size of the window
 * @param {Number} y - The starting y offset
 * @param {Number} width - The horizontal size of the window
 * @returns {Matrix} B - The generated subwindow from matrix `c`
 * @public
 * @memberOf matlab
 * @since 0.0.2
 */
function sub(_a, x, height, y, width) {
    var ref = _a.data, refWidth = _a.width;
    var data = new Array(width * height);
    for (var i = 0; i < height; i++) {
        for (var j = 0; j < width; j++) {
            data[i * width + j] = ref[(y + i) * refWidth + x + j];
        }
    }
    return {
        data: data,
        width: width,
        height: height,
    };
}
exports.sub = sub;
//# sourceMappingURL=sub.js.map